<?php
session_start();
if (empty($_SESSION['admin_authed'])) {
    header('Location: login.php');
    exit;
}

require __DIR__ . '/../lib/db.php';
$pdo = db_connect();

$defaults = [
    'hero_headline' => 'Your Trusted Partner in Security',
    'hero_subheadline' => 'Professional Security Services for Homes, Businesses, and Events',
    'hero_cta' => 'Request a Quote',
    'about_headline' => 'About ArcoamSecurity',
    'about_text' => 'With over a decade of excellence in security services, ArcoamSecurity has established itself as a trusted leader in comprehensive protection solutions.',
    'services_headline' => 'Our Services',
    'services_subtext' => 'Comprehensive security solutions tailored to your unique needs',
    'case_headline' => 'Success Stories',
    'case_subtext' => 'Real results from our security implementations',
    'testimonials_headline' => 'Client Testimonials',
    'testimonials_subtext' => 'Hear what our satisfied clients have to say',
    'blog_headline' => 'Security Insights',
    'blog_subtext' => 'Expert tips, industry news, and security best practices',
    'contact_headline' => 'Get in Touch',
    'contact_subtext' => 'Ready to secure your property? Contact us for a free consultation',
    'contact_hotline' => '+1 (555) 123-4567',
    'contact_hotline_subtext' => 'Available round-the-clock',
    'contact_email_primary' => 'info@arcoamsecurity.com',
    'contact_email_secondary' => 'emergency@arcoamsecurity.com',
    'contact_office_hours' => 'Mon-Fri: 8AM-6PM EST',
    'contact_address' => "123 Security Boulevard\nSuite 500\nNew York, NY 10001",
    'footer_tagline' => 'Protecting what matters most, 24/7',
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $updates = [];
    foreach (array_keys($defaults) as $key) {
        $updates[$key] = trim($_POST[$key] ?? '');
    }
    db_set_settings($pdo, $updates);
    $saved = true;
}

$settings = array_merge($defaults, db_get_settings($pdo));
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Admin - Site Settings</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&display=swap" rel="stylesheet">
  <style>
    body { font-family: 'Montserrat', sans-serif; background: #0f172a; color: #e2e8f0; margin: 0; }
    .wrap { max-width: 900px; margin: 40px auto; background: #1e293b; padding: 32px; border-radius: 14px; box-shadow: 0 20px 60px rgba(0,0,0,0.45); }
    h1 { margin: 0 0 8px; color: #f8fafc; }
    p.sub { margin-top: 0; color: #cbd5e1; }
    .layout { display: grid; grid-template-columns: 240px 1fr; gap: 20px; }
    .sidenav { background: #0f172a; padding: 16px; border-radius: 12px; border: 1px solid #334155; position: sticky; top: 20px; height: fit-content; }
    .sidenav a { display: block; padding: 10px 12px; color: #cbd5e1; text-decoration: none; border-radius: 8px; margin-bottom: 6px; }
    .sidenav a:hover { background: #334155; color: #f8fafc; }
    form { display: grid; gap: 16px; }
    label { font-weight: 600; margin-bottom: 6px; display: block; }
    input[type="text"], textarea { width: 100%; padding: 12px; border-radius: 10px; border: 1px solid #334155; background: #0f172a; color: #e2e8f0; }
    textarea { min-height: 120px; resize: vertical; }
    button { width: 180px; padding: 12px; background: #d97706; color: #0f172a; border: none; border-radius: 10px; font-weight: 700; cursor: pointer; }
    .row { display: grid; gap: 12px; }
    .notice { background: #0f172a; border: 1px solid #334155; padding: 12px; border-radius: 10px; color: #cbd5e1; }
    .success { border-color: #16a34a; color: #bbf7d0; }
    .topbar { display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px; }
    .logout { color: #f87171; text-decoration: none; font-weight: 700; }
  </style>
</head>
<body>
  <div class="wrap">
    <div class="topbar">
      <div>
        <h1>Site Settings</h1>
        <p class="sub">Update key copy across the site.</p>
      </div>
      <a class="logout" href="logout.php">Logout</a>
    </div>
    <?php if (!empty($saved)): ?>
      <div class="notice success">Changes saved.</div>
    <?php endif; ?>
    <div class="layout">
      <nav class="sidenav">
        <a href="#hero">Hero</a>
        <a href="#about">About</a>
        <a href="#services">Services</a>
        <a href="#case">Case Studies</a>
        <a href="#testimonials">Testimonials</a>
        <a href="#blog">Blog</a>
        <a href="#contact">Contact</a>
        <a href="#footer">Footer</a>
      </nav>
      <form method="post">
        <div id="hero" class="row">
          <label for="hero_headline">Hero Headline</label>
          <input type="text" id="hero_headline" name="hero_headline" value="<?= htmlspecialchars($settings['hero_headline'], ENT_QUOTES, 'UTF-8') ?>" required>
        </div>
        <div class="row">
          <label for="hero_subheadline">Hero Subheadline</label>
          <input type="text" id="hero_subheadline" name="hero_subheadline" value="<?= htmlspecialchars($settings['hero_subheadline'], ENT_QUOTES, 'UTF-8') ?>" required>
        </div>
        <div class="row">
          <label for="hero_cta">Hero CTA Text</label>
          <input type="text" id="hero_cta" name="hero_cta" value="<?= htmlspecialchars($settings['hero_cta'], ENT_QUOTES, 'UTF-8') ?>" required>
        </div>

        <hr>
        <div id="about" class="row">
          <label for="about_headline">About Headline</label>
          <input type="text" id="about_headline" name="about_headline" value="<?= htmlspecialchars($settings['about_headline'], ENT_QUOTES, 'UTF-8') ?>" required>
        </div>
        <div class="row">
          <label for="about_text">About Text</label>
          <textarea id="about_text" name="about_text" required><?= htmlspecialchars($settings['about_text'], ENT_QUOTES, 'UTF-8') ?></textarea>
        </div>

        <hr>
        <div id="services" class="row">
          <label for="services_headline">Services Headline</label>
          <input type="text" id="services_headline" name="services_headline" value="<?= htmlspecialchars($settings['services_headline'], ENT_QUOTES, 'UTF-8') ?>" required>
        </div>
        <div class="row">
          <label for="services_subtext">Services Subtext</label>
          <textarea id="services_subtext" name="services_subtext" required><?= htmlspecialchars($settings['services_subtext'], ENT_QUOTES, 'UTF-8') ?></textarea>
        </div>

        <hr>
        <div id="case" class="row">
          <label for="case_headline">Case Studies Headline</label>
          <input type="text" id="case_headline" name="case_headline" value="<?= htmlspecialchars($settings['case_headline'], ENT_QUOTES, 'UTF-8') ?>" required>
        </div>
        <div class="row">
          <label for="case_subtext">Case Studies Subtext</label>
          <textarea id="case_subtext" name="case_subtext" required><?= htmlspecialchars($settings['case_subtext'], ENT_QUOTES, 'UTF-8') ?></textarea>
        </div>

        <hr>
        <div id="testimonials" class="row">
          <label for="testimonials_headline">Testimonials Headline</label>
          <input type="text" id="testimonials_headline" name="testimonials_headline" value="<?= htmlspecialchars($settings['testimonials_headline'], ENT_QUOTES, 'UTF-8') ?>" required>
        </div>
        <div class="row">
          <label for="testimonials_subtext">Testimonials Subtext</label>
          <textarea id="testimonials_subtext" name="testimonials_subtext" required><?= htmlspecialchars($settings['testimonials_subtext'], ENT_QUOTES, 'UTF-8') ?></textarea>
        </div>

        <hr>
        <div id="blog" class="row">
          <label for="blog_headline">Blog Headline</label>
          <input type="text" id="blog_headline" name="blog_headline" value="<?= htmlspecialchars($settings['blog_headline'], ENT_QUOTES, 'UTF-8') ?>" required>
        </div>
        <div class="row">
          <label for="blog_subtext">Blog Subtext</label>
          <textarea id="blog_subtext" name="blog_subtext" required><?= htmlspecialchars($settings['blog_subtext'], ENT_QUOTES, 'UTF-8') ?></textarea>
        </div>

        <hr>
        <div id="contact" class="row">
          <label for="contact_headline">Contact Headline</label>
          <input type="text" id="contact_headline" name="contact_headline" value="<?= htmlspecialchars($settings['contact_headline'], ENT_QUOTES, 'UTF-8') ?>" required>
        </div>
        <div class="row">
          <label for="contact_subtext">Contact Subtext</label>
          <textarea id="contact_subtext" name="contact_subtext" required><?= htmlspecialchars($settings['contact_subtext'], ENT_QUOTES, 'UTF-8') ?></textarea>
        </div>
        <div class="row">
          <label for="contact_hotline">Hotline Number</label>
          <input type="text" id="contact_hotline" name="contact_hotline" value="<?= htmlspecialchars($settings['contact_hotline'], ENT_QUOTES, 'UTF-8') ?>" required>
        </div>
        <div class="row">
          <label for="contact_hotline_subtext">Hotline Subtext</label>
          <input type="text" id="contact_hotline_subtext" name="contact_hotline_subtext" value="<?= htmlspecialchars($settings['contact_hotline_subtext'], ENT_QUOTES, 'UTF-8') ?>" required>
        </div>
        <div class="row">
          <label for="contact_email_primary">Primary Email</label>
          <input type="text" id="contact_email_primary" name="contact_email_primary" value="<?= htmlspecialchars($settings['contact_email_primary'], ENT_QUOTES, 'UTF-8') ?>" required>
        </div>
        <div class="row">
          <label for="contact_email_secondary">Secondary Email</label>
          <input type="text" id="contact_email_secondary" name="contact_email_secondary" value="<?= htmlspecialchars($settings['contact_email_secondary'], ENT_QUOTES, 'UTF-8') ?>" required>
        </div>
        <div class="row">
          <label for="contact_office_hours">Office Hours</label>
          <input type="text" id="contact_office_hours" name="contact_office_hours" value="<?= htmlspecialchars($settings['contact_office_hours'], ENT_QUOTES, 'UTF-8') ?>" required>
        </div>
        <div class="row">
          <label for="contact_address">Address (HTML allowed)</label>
          <textarea id="contact_address" name="contact_address" required><?= htmlspecialchars($settings['contact_address'], ENT_QUOTES, 'UTF-8') ?></textarea>
        </div>

        <hr>
        <div id="footer" class="row">
          <label for="footer_tagline">Footer Tagline</label>
          <input type="text" id="footer_tagline" name="footer_tagline" value="<?= htmlspecialchars($settings['footer_tagline'], ENT_QUOTES, 'UTF-8') ?>" required>
        </div>

        <button type="submit">Save Changes</button>
      </form>
    </div>
  </div>
</body>
</html>
