<?php
session_start();
$config = require __DIR__ . '/../config.php';

$error = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password = $_POST['password'] ?? '';
    if (hash_equals($config['admin_password'], $password)) {
        $_SESSION['admin_authed'] = true;
        header('Location: index.php');
        exit;
    }
    $error = 'Invalid password';
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Admin Login</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600&display=swap" rel="stylesheet">
  <style>
    body { font-family: 'Montserrat', sans-serif; background: #0f172a; color: #e2e8f0; display: flex; align-items: center; justify-content: center; min-height: 100vh; margin: 0; }
    .card { background: #1e293b; padding: 32px; border-radius: 12px; width: 100%; max-width: 360px; box-shadow: 0 20px 50px rgba(0,0,0,0.4); }
    h1 { margin-top: 0; margin-bottom: 16px; color: #f8fafc; }
    label { display: block; margin-bottom: 8px; font-weight: 600; }
    input { width: 100%; padding: 12px; border-radius: 8px; border: 1px solid #334155; background: #0f172a; color: #e2e8f0; }
    button { margin-top: 16px; width: 100%; padding: 12px; background: #d97706; color: #0f172a; border: none; border-radius: 8px; font-weight: 700; cursor: pointer; }
    .error { color: #fca5a5; margin-top: 12px; }
    .hint { margin-top: 16px; font-size: 12px; color: #cbd5e1; }
  </style>
</head>
<body>
  <div class="card">
    <h1>Admin Login</h1>
    <?php if ($error): ?>
      <div class="error"><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8') ?></div>
    <?php endif; ?>
    <form method="post">
      <label for="password">Password</label>
      <input type="password" name="password" id="password" required>
      <button type="submit">Sign In</button>
    </form>
    <div class="hint">Default password is "changeme" (set in config.php) — change it after logging in.</div>
  </div>
</body>
</html>
