<?php
header('Content-Type: application/json');
require __DIR__ . '/../lib/db.php';

$pdo = db_connect();

$defaults = [
    'hero_headline' => 'Your Trusted Partner in Security',
    'hero_subheadline' => 'Professional Security Services for Homes, Businesses, and Events',
    'hero_cta' => 'Request a Quote',
    'about_headline' => 'About ArcoamSecurity',
    'about_text' => 'With over a decade of excellence in security services, ArcoamSecurity has established itself as a trusted leader in comprehensive protection solutions. Our commitment to safety, cutting-edge technology, and professional expertise ensures that your assets, people, and peace of mind are always protected.',
    'services_headline' => 'Our Services',
    'services_subtext' => 'Comprehensive security solutions tailored to your unique needs',
    'case_headline' => 'Success Stories',
    'case_subtext' => 'Real results from our security implementations',
    'testimonials_headline' => 'Client Testimonials',
    'testimonials_subtext' => 'Hear what our satisfied clients have to say',
    'blog_headline' => 'Security Insights',
    'blog_subtext' => 'Expert tips, industry news, and security best practices',
    'contact_headline' => 'Get in Touch',
    'contact_subtext' => 'Ready to secure your property? Contact us for a free consultation',
    'contact_hotline' => '+1 (555) 123-4567',
    'contact_hotline_subtext' => 'Available round-the-clock',
    'contact_email_primary' => 'info@arcoamsecurity.com',
    'contact_email_secondary' => 'emergency@arcoamsecurity.com',
    'contact_office_hours' => 'Mon-Fri: 8AM-6PM EST',
    'contact_address' => '123 Security Boulevard<br>Suite 500<br>New York, NY 10001',
    'footer_tagline' => 'Protecting what matters most, 24/7',
];

$settings = array_merge($defaults, db_get_settings($pdo));
echo json_encode($settings);
