const defaultConfig = {
  hero_headline: "Your Trusted Partner in Security",
  hero_subheadline: "Professional Security Services for Homes, Businesses, and Events",
  hero_cta: "Request a Quote",
  about_headline: "About ArcoamSecurity",
  about_text: "With over a decade of excellence in security services, ArcoamSecurity has established itself as a trusted leader in comprehensive protection solutions. Our commitment to safety, cutting-edge technology, and professional expertise ensures that your assets, people, and peace of mind are always protected.",
  services_headline: "Our Services",
  services_subtext: "Comprehensive security solutions tailored to your unique needs",
  case_headline: "Success Stories",
  case_subtext: "Real results from our security implementations",
  testimonials_headline: "Client Testimonials",
  testimonials_subtext: "Hear what our satisfied clients have to say",
  blog_headline: "Security Insights",
  blog_subtext: "Expert tips, industry news, and security best practices",
  contact_headline: "Get in Touch",
  contact_subtext: "Ready to secure your property? Contact us for a free consultation",
  contact_hotline: "+1 (555) 123-4567",
  contact_hotline_subtext: "Available round-the-clock",
  contact_email_primary: "info@arcoamsecurity.com",
  contact_email_secondary: "emergency@arcoamsecurity.com",
  contact_office_hours: "Mon-Fri: 8AM-6PM EST",
  contact_address: "123 Security Boulevard<br>Suite 500<br>New York, NY 10001",
  footer_tagline: "Protecting what matters most, 24/7"
};

async function onConfigChange(config) {
  document.getElementById('hero-headline').innerHTML = `${(config.hero_headline || defaultConfig.hero_headline).split(' ').slice(0, -1).join(' ')} <span class="text-amber-600">${(config.hero_headline || defaultConfig.hero_headline).split(' ').slice(-1)[0]}</span>`;
  document.getElementById('hero-subheadline').textContent = config.hero_subheadline || defaultConfig.hero_subheadline;
  document.getElementById('hero-cta-btn').textContent = config.hero_cta || defaultConfig.hero_cta;
  document.getElementById('about-headline').innerHTML = `${(config.about_headline || defaultConfig.about_headline).split(' ').slice(0, -1).join(' ')} <span class="text-amber-600">${(config.about_headline || defaultConfig.about_headline).split(' ').slice(-1)[0]}</span>`;
  document.getElementById('about-text').textContent = config.about_text || defaultConfig.about_text;
  document.getElementById('footer-tagline').textContent = config.footer_tagline || defaultConfig.footer_tagline;

  const setText = (id, value, isHtml = false) => {
    const el = document.getElementById(id);
    if (el) {
      if (isHtml) {
        el.innerHTML = value;
      } else {
        el.textContent = value;
      }
    }
  };

  setText('services-headline', config.services_headline || defaultConfig.services_headline);
  setText('services-subtext', config.services_subtext || defaultConfig.services_subtext);
  setText('case-headline', config.case_headline || defaultConfig.case_headline);
  setText('case-subtext', config.case_subtext || defaultConfig.case_subtext);
  setText('testimonials-headline', config.testimonials_headline || defaultConfig.testimonials_headline);
  setText('testimonials-subtext', config.testimonials_subtext || defaultConfig.testimonials_subtext);
  setText('blog-headline', config.blog_headline || defaultConfig.blog_headline);
  setText('blog-subtext', config.blog_subtext || defaultConfig.blog_subtext);
  setText('contact-headline', config.contact_headline || defaultConfig.contact_headline);
  setText('contact-subtext', config.contact_subtext || defaultConfig.contact_subtext);
  setText('contact-hotline', config.contact_hotline || defaultConfig.contact_hotline);
  setText('contact-hotline-subtext', config.contact_hotline_subtext || defaultConfig.contact_hotline_subtext);
  setText('contact-email-primary', config.contact_email_primary || defaultConfig.contact_email_primary);
  setText('contact-email-secondary', config.contact_email_secondary || defaultConfig.contact_email_secondary);
  setText('contact-office-hours', config.contact_office_hours || defaultConfig.contact_office_hours);
  setText('contact-address', config.contact_address || defaultConfig.contact_address, true);
}

function mapToCapabilities(config) {
  return {
    recolorables: [],
    borderables: [],
    fontEditable: undefined,
    fontSizeable: undefined
  };
}

function mapToEditPanelValues(config) {
  return new Map([
    ["hero_headline", config.hero_headline || defaultConfig.hero_headline],
    ["hero_subheadline", config.hero_subheadline || defaultConfig.hero_subheadline],
    ["hero_cta", config.hero_cta || defaultConfig.hero_cta],
    ["about_headline", config.about_headline || defaultConfig.about_headline],
    ["about_text", config.about_text || defaultConfig.about_text],
    ["footer_tagline", config.footer_tagline || defaultConfig.footer_tagline]
  ]);
}

if (window.elementSdk) {
  window.elementSdk.init({
    defaultConfig,
    onConfigChange,
    mapToCapabilities,
    mapToEditPanelValues
  });
}

async function fetchSettings() {
  try {
    const res = await fetch('api/settings.php', { cache: 'no-store' });
    if (!res.ok) throw new Error('Failed to load settings');
    const data = await res.json();
    await onConfigChange(data);
  } catch (err) {
    console.warn('Settings fetch failed, using defaults', err);
    await onConfigChange(defaultConfig);
  }
}

// Scroll reveal animation with stagger effect
const observerOptions = {
  threshold: 0.1,
  rootMargin: '0px 0px -50px 0px'
};

const observer = new IntersectionObserver((entries) => {
  entries.forEach((entry) => {
    if (entry.isIntersecting) {
      const parent = entry.target.parentElement;
      const siblings = Array.from(parent.children).filter(child =>
        child.classList.contains('scroll-reveal')
      );
      const elementIndex = siblings.indexOf(entry.target);

      setTimeout(() => {
        entry.target.classList.add('active');
      }, elementIndex * 100);
    }
  });
}, observerOptions);

document.querySelectorAll('.scroll-reveal').forEach(el => {
  observer.observe(el);
});

// Smooth scrolling
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
  anchor.addEventListener('click', function (e) {
    e.preventDefault();
    const target = document.querySelector(this.getAttribute('href'));
    if (target) {
      target.scrollIntoView({
        behavior: 'smooth',
        block: 'start'
      });
    }
  });
});

// Contact form handling
document.getElementById('contact-form').addEventListener('submit', function (e) {
  e.preventDefault();

  const formMessage = document.getElementById('form-message');
  formMessage.textContent = 'Thank you for your message! Our team will contact you within 24 hours.';
  formMessage.className = 'mt-4 p-4 rounded-lg bg-green-900 text-green-100 border border-green-700';
  formMessage.classList.remove('hidden');

  this.reset();

  setTimeout(() => {
    formMessage.classList.add('hidden');
  }, 5000);
});

// Newsletter form handling
document.getElementById('newsletter-form').addEventListener('submit', function (e) {
  e.preventDefault();

  const newsletterMessage = document.getElementById('newsletter-message');
  const emailInput = document.getElementById('newsletter-email');

  newsletterMessage.textContent = `dYZ% Success! Welcome to our community. Check ${emailInput.value} for a confirmation email.`;
  newsletterMessage.className = 'mt-4 p-4 rounded-lg bg-white text-slate-900 font-semibold';
  newsletterMessage.classList.remove('hidden');

  this.reset();

  setTimeout(() => {
    newsletterMessage.classList.add('hidden');
  }, 6000);
});

// Hero CTA button scroll
document.getElementById('hero-cta-btn').addEventListener('click', function (e) {
  e.preventDefault();
  document.getElementById('contact').scrollIntoView({
    behavior: 'smooth',
    block: 'start'
  });
});

// Free consultation button scroll and pre-fill
document.getElementById('free-consultation-btn').addEventListener('click', function (e) {
  e.preventDefault();
  const serviceSelect = document.getElementById('service');
  serviceSelect.value = 'consultation';
  document.getElementById('contact-form').scrollIntoView({
    behavior: 'smooth',
    block: 'center'
  });
  const formContainer = document.getElementById('contact-form').parentElement;
  formContainer.style.boxShadow = '0 0 30px rgba(217, 119, 6, 0.5)';
  setTimeout(() => {
    formContainer.style.boxShadow = '';
  }, 2000);
});

// Hero Slider Functionality
let currentSlide = 0;
const slides = document.querySelectorAll('.slide');
const dots = document.querySelectorAll('.slider-dot');
const totalSlides = slides.length;
let slideInterval;

function showSlide(index) {
  slides.forEach((slide, i) => {
    slide.classList.remove('active');
    dots[i].classList.remove('active');
  });

  currentSlide = (index + totalSlides) % totalSlides;
  slides[currentSlide].classList.add('active');
  dots[currentSlide].classList.add('active');
}

function nextSlide() {
  showSlide(currentSlide + 1);
}

function prevSlide() {
  showSlide(currentSlide - 1);
}

function startAutoSlide() {
  slideInterval = setInterval(nextSlide, 5000);
}

function stopAutoSlide() {
  clearInterval(slideInterval);
}

document.querySelector('.slider-arrow.left').addEventListener('click', () => {
  stopAutoSlide();
  prevSlide();
  startAutoSlide();
});

document.querySelector('.slider-arrow.right').addEventListener('click', () => {
  stopAutoSlide();
  nextSlide();
  startAutoSlide();
});

dots.forEach((dot, index) => {
  dot.addEventListener('click', () => {
    stopAutoSlide();
    showSlide(index);
    startAutoSlide();
  });
});

startAutoSlide();

const heroSection = document.getElementById('home');
heroSection.addEventListener('mouseenter', stopAutoSlide);
heroSection.addEventListener('mouseleave', startAutoSlide);

// Load dynamic settings at end to update copy
fetchSettings();
