<?php

function db_connect(): PDO
{
    $config = require __DIR__ . '/../config.php';
    $path = $config['sqlite_path'];
    $dir = dirname($path);
    if (!is_dir($dir)) {
        mkdir($dir, 0777, true);
    }

    $pdo = new PDO('sqlite:' . $path);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);

    $pdo->exec("
        CREATE TABLE IF NOT EXISTS settings (
            key TEXT PRIMARY KEY,
            value TEXT NOT NULL,
            updated_at TEXT DEFAULT CURRENT_TIMESTAMP
        )
    ");

    return $pdo;
}

function db_get_settings(PDO $pdo): array
{
    $stmt = $pdo->query("SELECT key, value FROM settings");
    $out = [];
    foreach ($stmt as $row) {
        $out[$row['key']] = $row['value'];
    }
    return $out;
}

function db_set_settings(PDO $pdo, array $data): void
{
    $stmt = $pdo->prepare("INSERT OR REPLACE INTO settings (key, value, updated_at) VALUES (:key, :value, CURRENT_TIMESTAMP)");
    foreach ($data as $key => $value) {
        $stmt->execute([':key' => $key, ':value' => $value]);
    }
}
