<section id="case-studies" class="py-20 bg-slate-900">
  <div class="max-w-7xl mx-auto px-6">
    <div class="scroll-reveal text-center mb-16">
      <h2 id="case-headline" class="text-4xl md:text-5xl font-bold mb-6">Success <span class="text-amber-600">Stories</span></h2>
      <p id="case-subtext" class="text-xl text-gray-300 max-w-3xl mx-auto">Real results from our security implementations</p>
    </div>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
      <div class="scroll-reveal service-card bg-slate-800 rounded-lg overflow-hidden border border-gray-700">
        <div class="h-64 overflow-hidden relative">
          <img src="https://images.unsplash.com/photo-1486406146926-c627a92ad1ab?w=800&q=80" alt="Corporate Campus Security" class="w-full h-full object-cover" onerror="this.src=''; this.alt='Image failed to load'; this.style.display='none';">
          <div class="absolute inset-0 bg-gradient-to-t from-slate-800 to-transparent"></div>
        </div>
        <div class="p-6">
          <h3 class="text-2xl font-bold mb-3">Fortune 500 Corporate Campus</h3>
          <p class="text-gray-400 mb-4">Implemented comprehensive security system for a 50-acre corporate campus with 2,000+ employees.</p>
          <div class="space-y-2 mb-4">
            <div class="flex items-center text-amber-600">
              <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z" /></svg>
              <span>40% reduction in security incidents</span>
            </div>
            <div class="flex items-center text-amber-600">
              <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z" /></svg>
              <span>24/7 monitoring coverage</span>
            </div>
            <div class="flex items-center text-amber-600">
              <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z" /></svg>
              <span>98% employee satisfaction rate</span>
            </div>
          </div>
        </div>
      </div>
      <div class="scroll-reveal service-card bg-slate-800 rounded-lg overflow-hidden border border-gray-700">
        <div class="h-64 overflow-hidden relative">
          <img src="https://images.unsplash.com/photo-1470229722913-7c0e2dbbafd3?w=800&q=80" alt="Music Festival Security" class="w-full h-full object-cover" onerror="this.src=''; this.alt='Image failed to load'; this.style.display='none';">
          <div class="absolute inset-0 bg-gradient-to-t from-slate-800 to-transparent"></div>
        </div>
        <div class="p-6">
          <h3 class="text-2xl font-bold mb-3">Music Festival - 50,000 Attendees</h3>
          <p class="text-gray-400 mb-4">Provided complete event security for a three-day music festival with multiple stages.</p>
          <div class="space-y-2 mb-4">
            <div class="flex items-center text-amber-600">
              <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z" /></svg>
              <span>Zero major security incidents</span>
            </div>
            <div class="flex items-center text-amber-600">
              <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z" /></svg>
              <span>150+ security personnel deployed</span>
            </div>
            <div class="flex items-center text-amber-600">
              <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z" /></svg>
              <span>Smooth crowd management</span>
            </div>
          </div>
        </div>
      </div>
      <div class="scroll-reveal service-card bg-slate-800 rounded-lg overflow-hidden border border-gray-700">
        <div class="h-64 overflow-hidden relative">
          <img src="https://images.unsplash.com/photo-1564013799919-ab600027ffc6?w=800&q=80" alt="Luxury Residential Community" class="w-full h-full object-cover" onerror="this.src=''; this.alt='Image failed to load'; this.style.display='none';">
          <div class="absolute inset-0 bg-gradient-to-t from-slate-800 to-transparent"></div>
        </div>
        <div class="p-6">
          <h3 class="text-2xl font-bold mb-3">Luxury Residential Community</h3>
          <p class="text-gray-400 mb-4">Advanced security system for a gated community with 200 homes and premium amenities.</p>
          <div class="space-y-2 mb-4">
            <div class="flex items-center text-amber-600">
              <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z" /></svg>
              <span>65% decrease in property crime</span>
            </div>
            <div class="flex items-center text-amber-600">
              <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z" /></svg>
              <span>Smart access control system</span>
            </div>
            <div class="flex items-center text-amber-600">
              <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z" /></svg>
              <span>100% resident satisfaction</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Trusted Partners Section -->
<section class="py-20 bg-gradient-to-br from-amber-600 via-orange-600 to-amber-700 relative overflow-hidden">
  <!-- Animated background pattern -->
  <div class="absolute inset-0 opacity-10">
    <div class="absolute top-0 left-0 w-64 h-64 bg-white rounded-full blur-3xl"></div>
    <div class="absolute bottom-0 right-0 w-96 h-96 bg-white rounded-full blur-3xl"></div>
  </div>
  <div class="max-w-7xl mx-auto px-6 relative z-10">
    <div class="scroll-reveal text-center mb-12">
      <div class="inline-flex items-center justify-center mb-6">
        <svg class="w-12 h-12 text-white mr-4" fill="currentColor" viewBox="0 0 24 24"><path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4z" /></svg>
        <h2 class="text-4xl md:text-5xl font-bold text-white">Trusted by Industry Leaders</h2>
      </div>
      <p class="text-xl text-white max-w-3xl mx-auto opacity-95">Providing world-class security solutions to Fortune 500 companies and premier organizations</p>
    </div>
    <!-- Logo Grid -->
    <div class="scroll-reveal bg-white rounded-2xl p-8 md:p-12 shadow-2xl">
      <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-5 gap-8 md:gap-12 items-center">
        <!-- Amazon -->
        <div class="partner-logo flex items-center justify-center p-4 rounded-lg transition-all duration-300 hover:scale-110 hover:bg-slate-50">
          <svg viewBox="0 0 200 60" class="w-full h-12" fill="#232F3E"><path d="M107.5 35.5c-6.7 4.9-16.3 7.5-24.6 7.5-11.6 0-22.1-4.3-30-11.5-.6-.5-.1-1.3.7-.9 8.6 5 19.2 8 30.2 8 7.4 0 15.5-1.5 23-4.7 1.1-.5 2 .7.7 1.6zm2.8-3.2c-.9-1.1-5.7-.5-7.9-.3-.7.1-.8-.5-.2-1 3.8-2.7 10.1-1.9 10.8-1 .7.9-.2 7.2-3.8 10.2-.5.5-1.1.2-.8-.4.8-2.1 2.7-6.7 1.9-7.5z" /><path d="M97.5 11.8V8.3c0-.5.4-.9.9-.9h16.2c.5 0 .9.4.9.9v3c0 .5-.4 1.1-1.1 2.1l-8.4 12c3.1-.1 6.4.4 9.2 2 .6.4.8.9.8 1.5v3.7c0 .5-.6 1.1-1.2.8-4.9-2.6-11.4-2.9-16.8.1-.5.3-1.2-.3-1.2-.8v-3.5c0-.6 0-1.6.6-2.5l9.7-13.9h-8.5c-.5 0-.9-.4-.9-.9zm-38.1 23.7h-4.7c-.5 0-.8-.3-.9-.8V8.4c0-.5.4-.9.9-.9h4.4c.5 0 .8.3.9.8v3.2h.1c1.2-3.1 3.5-4.6 6.5-4.6 3.1 0 5 1.5 6.4 4.6 1.2-3.1 4.1-4.6 6.8-4.6 2.1 0 4.3.9 5.7 2.8 1.6 2.1 1.2 5.2 1.2 7.9l-.1 17c0 .5-.4.9-.9.9h-4.7c-.5 0-.8-.4-.9-.9V18.5c0-1.1.1-3.8-.1-4.8-.4-1.7-1.5-2.2-2.9-2.2-1.2 0-2.5.8-3 2.1-.5 1.3-.5 3.4-.5 4.9v16.2c0 .5-.4.9-.9.9h-4.7c-.5 0-.8-.4-.9-.9l-.1-16.2c0-3.4.6-8.4-3.1-8.4-3.7 0-3.6 4.3-3.6 8.4v16.2c0 .5-.4.9-.9.9zm66.3 1c-6.9 0-14.6-3-14.6-12.9 0-9.9 7.7-12.5 14.6-12.5 6.9 0 14.6 3 14.6 12.9 0 9.9-7.7 12.5-14.6 12.5zm0-4.8c3.5 0 3.7-4.8 3.7-7.8s-.1-9.4-3.7-9.4c-3.5 0-3.7 4.8-3.7 7.8 0 3 0 9.4 3.7 9.4zm25.8 4.8c-4.7 0-9.9-2.1-9.9-7.9 0-8.5 7.7-10 14.9-10 2.6 0 5.2.1 7.7.2v-1.3c0-2.2.2-4.8-.9-6.7-.9-1.6-2.7-2.3-4.3-2.3-2.9 0-5.5 1.5-6.1 4.6-.1.7-.6 1.3-1.3 1.3l-4.5-.5c-.6-.1-1.3-.6-1.1-1.5 1.6-8.5 9.3-11.1 16.2-11.1 3.5 0 8.1.9 10.9 3.6 3.5 3.4 3.2 7.9 3.2 12.8v11.6c0 3.5 1.4 5 2.8 6.9.5.7.6 1.5-.1 2-.9.8-2.6 2.2-3.5 3-.5.4-1.1.3-1.6-.2-1.3-1.5-1.7-2.2-2.5-3.6-2.4 3.1-5.6 4.2-9.9 4.2zm1-10.3c0 2.8-.1 5.1-1.4 7.4-1 1.9-2.6 3-4.4 3-2.5 0-3.9-1.9-3.9-4.7 0-5.5 4.9-6.5 9.6-6.5v.8zm-50.1 10.1h-4.7c-.5 0-.8-.4-.9-.9V8.4c0-.5.4-.9.9-.9h4.4c.4 0 .8.3.9.7v3.8h.1c1.4-3.5 3.4-5.1 6.8-5.1 2.2 0 4.4.8 5.8 3 1.3 2 1.3 5.4 1.3 7.8v17c0 .5-.4.9-.9.9h-4.7c-.5 0-.8-.4-.9-.8V18c0-3.4.4-8.4-3.7-8.4-1.4 0-2.7.9-3.4 2.3-.9 1.7-1 3.4-1 5.3v17.5c0 .5-.4 .9-.9 .9z" /></svg>
        </div>
        <!-- Microsoft -->
        <div class="partner-logo flex items-center justify-center p-4 rounded-lg transition-all duration-300 hover:scale-110 hover:bg-slate-50">
          <svg viewBox="0 0 200 60" class="w-full h-12"><rect width="28" height="28" fill="#F25022" /><rect x="30" width="28" height="28" fill="#7FBA00" /><rect y="30" width="28" height="28" fill="#00A4EF" /><rect x="30" y="30" width="28" height="28" fill="#FFB900" /><text x="70" y="38" font-family="Segoe UI, Arial" font-size="24" font-weight="600" fill="#5E5E5E">Microsoft</text></svg>
        </div>
        <!-- Apple -->
        <div class="partner-logo flex items-center justify-center p-4 rounded-lg transition-all duration-300 hover:scale-110 hover:bg-slate-50">
          <svg viewBox="0 0 200 60" class="w-full h-12" fill="#000000"><path d="M42.1 35.7c-.1 2.9 2.6 4.3 2.7 4.4-.1.1-4.2 14.4-13.8 14.4-3.3 0-5.9-1.9-9.3-1.9-3.5 0-6.3 1.9-9.3 1.9-9.6 0-17.6-14.7-17.6-28.9 0-14.2 8.9-21.7 17.1-21.7 3.2 0 6.5 2.1 9.2 2.1 2.6 0 6.3-2.3 10.6-2.3 1.8 0 6.6.2 10 4.9-.3 .2-6 3.5-5.9 10.4.1 8.4 7.4 11.2 7.3 11.7zM36.5 0c2.5 0 4.8 1.8 6.4 4.3 1.4 2.3 2.5 5.6 2.2 8.9-2.5-.1-5.6-1.7-7.4-3.9-1.6-2-3-5.2-2.6-8.3.5 0 .9-.1 1.4 0z" /><text x="55" y="38" font-family="San Francisco, Helvetica" font-size="32" font-weight="400" fill="#000000">Apple</text></svg>
        </div>
        <!-- Google -->
        <div class="partner-logo flex items-center justify-center p-4 rounded-lg transition-all duration-300 hover:scale-110 hover:bg-slate-50">
          <svg viewBox="0 0 200 60" class="w-full h-12"><path d="M29.5 24.2c0-1.6-.1-3.1-.4-4.5H15v8.5h8.1c-.4 1.9-1.4 3.5-3 4.6v5.5h4.9c2.8-2.6 4.5-6.4 4.5-10.6-.1-.3-.1-.7 0-1v-2.5z" fill="#4285F4" /><path d="M15 42c4.1 0 7.5-1.3 10-3.6l-4.9-3.8c-1.3 .9-3.1 1.4-5.1 1.4-3.9 0-7.2-2.6-8.4-6.2H1.5v3.9C4 37.9 9.1 42 15 42z" fill="#34A853" /><path d="M6.6 29.8c-.6-1.9-.6-3.9 0-5.8v-3.9H1.5c-2 4-2 8.7 0 12.7l5.1-3z" fill="#FBBC04" /><path d="M15 13.9c2.2 0 4.2 .8 5.7 2.3l4.3-4.3C22.5 9.3 19.1 7.5 15 7.5 9.1 7.5 4 11.6 1.5 15.8l5.1 3.9c1.2-3.6 4.5-6.2 8.4-5.8z" fill="#EA4335" /><text x="35" y="33" font-family="Product Sans, Arial" font-size="22" font-weight="500" fill="#5F6368">Google</text></svg>
        </div>
        <!-- Tesla -->
        <div class="partner-logo flex items-center justify-center p-4 rounded-lg transition-all duration-300 hover:scale-110 hover:bg-slate-50">
          <svg viewBox="0 0 200 60" class="w-full h-12" fill="#E82127"><path d="M30 10v5h-8.5v30h-8V15H5v-5h25zm12 0h7.5l9 25 9-25h7.5v35h-7.5V22.5l-9 22.5h-3l-9-22.5V45H42V10zm85 0v5H95v10h30v5H95v10h32v5H87V10h40z" /><text x="135" y="38" font-family="Arial" font-size="26" font-weight="700" fill="#000">TESLA</text></svg>
        </div>
        <!-- Goldman Sachs -->
        <div class="partner-logo flex items-center justify-center p-4 rounded-lg transition-all duration-300 hover:scale-110 hover:bg-slate-50">
          <svg viewBox="0 0 200 60" class="w-full h-12"><rect x="5" y="10" width="35" height="35" rx="3" fill="#0C2340" /><text x="10" y="33" font-family="Georgia, serif" font-size="20" font-weight="700" fill="#FFFFFF">GS</text><text x="48" y="25" font-family="Arial" font-size="11" font-weight="700" fill="#0C2340">GOLDMAN</text><text x="48" y="38" font-family="Arial" font-size="11" font-weight="700" fill="#0C2340">SACHS</text></svg>
        </div>
        <!-- Marriott -->
        <div class="partner-logo flex items-center justify-center p-4 rounded-lg transition-all duration-300 hover:scale-110 hover:bg-slate-50">
          <svg viewBox="0 0 200 60" class="w-full h-12" fill="#9E1B32"><text x="10" y="38" font-family="Garamond, serif" font-size="28" font-weight="700">MARRIOTT</text><rect x="5" y="45" width="120" height="2" /></svg>
        </div>
        <!-- JPMorgan -->
        <div class="partner-logo flex items-center justify-center p-4 rounded-lg transition-all duration-300 hover:scale-110 hover:bg-slate-50">
          <svg viewBox="0 0 200 60" class="w-full h-12"><path d="M15 10h25l-5 10h-20z" fill="#0070C0" /><path d="M10 25h30l-5 10H5z" fill="#0070C0" /><path d="M5 40h35l-5 10H0z" fill="#0070C0" /><text x="50" y="35" font-family="Arial" font-size="16" font-weight="700" fill="#0070C0">JPMorgan Chase</text></svg>
        </div>
        <!-- Boeing -->
        <div class="partner-logo flex items-center justify-center p-4 rounded-lg transition-all duration-300 hover:scale-110 hover:bg-slate-50">
          <svg viewBox="0 0 200 60" class="w-full h-12" fill="#0033A0"><circle cx="20" cy="30" r="15" fill="none" stroke="#0033A0" stroke-width="2" /><path d="M20 15v30M5 30h30" stroke="#0033A0" stroke-width="2" /><text x="45" y="38" font-family="Helvetica Neue" font-size="26" font-weight="700">BOEING</text></svg>
        </div>
        <!-- Hilton -->
        <div class="partner-logo flex items-center justify-center p-4 rounded-lg transition-all duration-300 hover:scale-110 hover:bg-slate-50">
          <svg viewBox="0 0 200 60" class="w-full h-12" fill="#002855"><rect x="5" y="15" width="4" height="25" /><rect x="13" y="15" width="4" height="25" /><rect x="9" y="25" width="8" height="4" /><text x="25" y="38" font-family="Helvetica" font-size="28" font-weight="400">Hilton</text></svg>
        </div>
      </div>
      <!-- Stats below logos -->
      <div class="grid grid-cols-3 gap-8 mt-12 pt-12 border-t-2 border-gray-200">
        <div class="text-center">
          <div class="text-4xl font-bold text-amber-600 mb-2">150+</div>
          <div class="text-gray-600 font-semibold">Enterprise Clients</div>
        </div>
        <div class="text-center">
          <div class="text-4xl font-bold text-amber-600 mb-2">25+</div>
          <div class="text-gray-600 font-semibold">Fortune 500 Companies</div>
        </div>
        <div class="text-center">
          <div class="text-4xl font-bold text-amber-600 mb-2">99.9%</div>
          <div class="text-gray-600 font-semibold">Client Retention Rate</div>
        </div>
      </div>
    </div>
  </div>
</section>
