<section id="contact" class="py-20 bg-slate-800">
  <div class="max-w-7xl mx-auto px-6">
    <div class="scroll-reveal text-center mb-16">
      <h2 id="contact-headline" class="text-4xl md:text-5xl font-bold mb-6">Get in <span class="text-amber-600">Touch</span></h2>
      <p id="contact-subtext" class="text-xl text-gray-300 max-w-3xl mx-auto">Ready to secure your property? Contact us for a free consultation</p>
      <button id="free-consultation-btn" class="btn-primary mt-6 bg-amber-600 hover:bg-amber-700 text-white font-bold py-4 px-10 rounded-lg text-lg inline-flex items-center">
        <svg class="w-6 h-6 mr-3" fill="currentColor" viewBox="0 0 24 24"><path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4z" /></svg>
        Get a Free Consultation
      </button>
    </div>
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
      <div class="scroll-reveal">
        <div class="bg-slate-900 p-8 rounded-lg border border-gray-700">
          <h3 class="text-2xl font-bold mb-6 flex items-center">
            <svg class="w-7 h-7 text-amber-600 mr-3" fill="currentColor" viewBox="0 0 24 24"><path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z" /></svg>
            Send Us a Message
          </h3>
          <form id="contact-form" class="space-y-6">
            <div>
              <label for="name" class="block text-sm font-semibold mb-2">Full Name *</label>
              <input type="text" id="name" name="name" required class="w-full px-4 py-3 bg-slate-800 border border-gray-600 rounded-lg focus:outline-none focus:border-amber-600 text-white transition">
            </div>
            <div>
              <label for="email" class="block text-sm font-semibold mb-2">Email Address *</label>
              <input type="email" id="email" name="email" required class="w-full px-4 py-3 bg-slate-800 border border-gray-600 rounded-lg focus:outline-none focus:border-amber-600 text-white transition">
            </div>
            <div>
              <label for="phone" class="block text-sm font-semibold mb-2">Phone Number</label>
              <input type="tel" id="phone" name="phone" class="w-full px-4 py-3 bg-slate-800 border border-gray-600 rounded-lg focus:outline-none focus:border-amber-600 text-white transition">
            </div>
            <div>
              <label for="service" class="block text-sm font-semibold mb-2">Service Needed</label>
              <select id="service" name="service" class="w-full px-4 py-3 bg-slate-800 border border-gray-600 rounded-lg focus:outline-none focus:border-amber-600 text-white transition">
                <option value="">Select a service...</option>
                <option value="armed-security">Armed Security</option>
                <option value="surveillance">Surveillance Systems</option>
                <option value="event-security">Event Security</option>
                <option value="corporate-security">Corporate Security</option>
                <option value="patrol-services">Patrol Services</option>
                <option value="residential-security">Residential Security</option>
                <option value="consultation">Free Consultation</option>
              </select>
            </div>
            <div>
              <label for="message" class="block text-sm font-semibold mb-2">Message *</label>
              <textarea id="message" name="message" rows="4" required class="w-full px-4 py-3 bg-slate-800 border border-gray-600 rounded-lg focus:outline-none focus:border-amber-600 text-white resize-none transition"></textarea>
            </div>
            <button type="submit" class="btn-primary w-full bg-amber-600 hover:bg-amber-700 text-white font-bold py-4 px-8 rounded-lg text-lg"> Send Message </button>
          </form>
          <div id="form-message" class="mt-4 p-4 rounded-lg hidden"></div>
        </div>
      </div>
      <div class="scroll-reveal space-y-8">
        <div class="contact-info-card bg-slate-900 p-8 rounded-lg border border-gray-700">
          <div class="flex items-start space-x-4">
            <svg class="w-8 h-8 text-amber-600 flex-shrink-0 mt-1" fill="currentColor" viewBox="0 0 24 24"><path d="M6.62 10.79c1.44 2.83 3.76 5.14 6.59 6.59l2.2-2.2c.27-.27.67-.36 1.02-.24 1.12 .37 2.33 .57 3.57 .57.55 0 1 .45 1 1V20c0 .55-.45 1-1 1-9.39 0-17-7.61-17-17 0-.55.45-1 1-1h3.5c.55 0 1 .45 1 1 0 1.25 .2 2.45 .57 3.57.11 .35 .03 .74-.25 1.02l-2.2 2.2z" /></svg>
            <div>
              <h3 class="text-xl font-bold mb-2">24/7 Emergency Hotline</h3>
              <p id="contact-hotline-subtext" class="text-gray-400">Available round-the-clock</p>
              <a id="contact-hotline" href="tel:+15551234567" class="text-amber-600 font-bold text-2xl mt-2 block hover:text-amber-500 transition">+1 (555) 123-4567</a>
            </div>
          </div>
        </div>
        <div class="contact-info-card bg-slate-900 p-8 rounded-lg border border-gray-700">
          <div class="flex items-start space-x-4">
            <svg class="w-8 h-8 text-amber-600 flex-shrink-0 mt-1" fill="currentColor" viewBox="0 0 24 24"><path d="M20 4H4c-1.1 0-1.99 .9-1.99 2L2 18c0 1.1 .9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z" /></svg>
            <div>
              <h3 class="text-xl font-bold mb-2">Email</h3>
              <p class="text-gray-400">Response within 24 hours</p>
              <a id="contact-email-primary" href="mailto:info@arcoamsecurity.com" class="text-amber-600 font-semibold mt-2 block hover:text-amber-500 transition">info@arcoamsecurity.com</a>
              <a id="contact-email-secondary" href="mailto:emergency@arcoamsecurity.com" class="text-amber-600 font-semibold block hover:text-amber-500 transition">emergency@arcoamsecurity.com</a>
            </div>
          </div>
        </div>
        <div class="contact-info-card bg-slate-900 p-8 rounded-lg border border-gray-700">
          <div class="flex items-start space-x-4">
            <svg class="w-8 h-8 text-amber-600 flex-shrink-0 mt-1" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z" /></svg>
            <div>
              <h3 class="text-xl font-bold mb-2">Office Location</h3>
              <p id="contact-office-hours" class="text-gray-400 mb-3">Mon-Fri: 8AM-6PM EST</p>
              <p id="contact-address" class="text-amber-600 font-semibold">123 Security Boulevard<br>Suite 500<br>New York, NY 10001</p>
              <a href="https://maps.google.com" target="_blank" rel="noopener noreferrer" class="text-amber-600 font-semibold mt-3 inline-flex items-center hover:text-amber-500 transition">
                Get Directions
                <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" /></svg>
              </a>
            </div>
          </div>
        </div>
        <!-- Embedded Map -->
        <div class="scroll-reveal">
          <div class="bg-slate-900 p-2 rounded-lg border border-gray-700 overflow-hidden">
            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3024.2219901290355!2d-74.00369368400567!3d40.71312937933017!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c25a316e7bd611%3A0x7a4f048f7e3d984!2sNew%20York%2C%20NY%2C%20USA!5e0!3m2!1sen!2s!4v1234567890123!5m2!1sen!2s" width="100%" height="300" style="border:0; border-radius: 0.5rem;" allowfullscreen loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
