<?php
require_once '../models/db_connection.php';

if (isset($_GET['studentID'])) {
    $studentID = mysqli_real_escape_string($conn, $_GET['studentID']); // student_id

    // Fetch the course price based on student enrollment (using courses table)
    $coursePrice = 0;
    $courseQuery = mysqli_query($conn, "
        SELECT courses.price 
        FROM student_course 
        JOIN courses ON student_course.course_id = courses.course_id 
        WHERE student_course.s_id = '$studentID'
        LIMIT 1
    ");
    if ($courseQuery && mysqli_num_rows($courseQuery) > 0) {
        $courseData = mysqli_fetch_assoc($courseQuery);
        $coursePrice = $courseData['price'] ?? 0;
    }

    // Fetch total payments made by the student
    $totalPaid = 0;
    $paymentsQuery = mysqli_query($conn, "
        SELECT SUM(student_payments.amount) as totalPaid
        FROM student_payments 
        WHERE student_payments.st_id = '$studentID'
    ");
    if ($paymentsQuery) {
        $paymentsData = mysqli_fetch_assoc($paymentsQuery);
        $totalPaid = $paymentsData['totalPaid'] ?? 0;
    }

    // Calculate remaining balance
    $remainingBalance = $coursePrice - $totalPaid;

    // Send response back as JSON
    echo json_encode([
        'coursePrice' => $coursePrice,
        'totalPaid' => $totalPaid,
        'remainingBalance' => $remainingBalance
    ]);
}
