<?php
// Card generator (separate from certificates_controller.php)
require('../fpdf186/fpdf.php');
require_once '../vendor/phpqrcode/qrlib.php';
require_once '../config/app.php';
session_start();
require_once '../models/db_connection.php';
require_once '../models/student_model.php';
require_once '../models/exam_model.php';
require_once '../models/course_model.php';

$course = new Course($conn);
$student = new Student($conn);
$exam = new Exam($conn);

$pdf = new FPDF('L', 'mm', [148, 84]); // Approx size for card (A6 landscape)

$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$publicResultUrlBase = $scheme . '://' . $appHost . '/public_result.php';

function generateCardId(): string
{
    return (string)random_int(10000000, 99999999);
}

function addCardQr(FPDF $pdf, $data)
{
    $tmpBase = tempnam(sys_get_temp_dir(), 'qr_');
    $tmpFile = $tmpBase . '.png';
    if (file_exists($tmpBase)) {
        unlink($tmpBase);
    }

    QRcode::png($data, $tmpFile, QR_ECLEVEL_L, 4, 2);

    $qrSize = 22;
    $pdf->Image($tmpFile, 118, 56, $qrSize, $qrSize, 'PNG');

    if (file_exists($tmpFile)) {
        unlink($tmpFile);
    }
}

function renderCard(FPDF $pdf, array $studentValue, string $publicResultUrlBase): void
{
    $pdf->AddPage();

    // Background template
    $pdf->Image(__DIR__ . '/card_template.jpg', 0, 0, $pdf->GetPageWidth(), $pdf->GetPageHeight());

    // Student photo (top-left box)
    if (!empty($studentValue['filename']) && file_exists("../uploads/" . $studentValue['filename'])) {
        $pdf->Image("../uploads/" . $studentValue['filename'], 4, 28, 28, 36);
    }

    // // Student name (center top)
    // $pdf->SetFont('Arial', 'B', 14);
    // $pdf->SetTextColor(0, 0, 0);
    // $pdf->SetXY(48, 16);
    // $pdf->Cell(80, 8, strtoupper($studentValue['fullname'] ?? ''), 0, 1, 'L');

    // // Current date
    // $pdf->SetFont('Arial', '', 11);
    // $pdf->SetXY(48, 26);
    // $pdf->Cell(60, 6, 'Issued: ' . date('d M Y'), 0, 1, 'L');

    // // Card ID (random per generation)
    // $cardId = generateCardId();
    // $pdf->SetFont('Arial', '', 8);
    // $pdf->SetXY(100, 57);
    // $pdf->Cell(60, 6, '' . $cardId, 1, 1, 'L');

    // Center statement text
    $pdf->SetFont('Arial', '', 8);
    $pdf->SetXY(34, 38);
    $statement = sprintf(
        '%s amehitimu mafunzo ya kozi ya HGV - Heavy Goods Vehicle na amefanikiwa kufaulu Mtihani wa Usalama Barabarani wa Jeshi la Polisi. Baada ya kuthibitishwa kukidhi vigezo vyote, ameruhusiwa kupewa Leseni ya Daraja E tarehe %s',
        $studentValue['fullname'] ?? '',
        date('d/m/Y')
    );
    $pdf->MultiCell(100, 5, $statement, 0, 'C');

    // Director signature/image (bottom center)
    $directorPathJpg = __DIR__ . '/director.jpg';
    $directorPathPng = __DIR__ . '/director.png';
    $directorPath = file_exists($directorPathJpg) ? $directorPathJpg : (file_exists($directorPathPng) ? $directorPathPng : null);
    if ($directorPath) {
        $pdf->Image($directorPath, 62, 62, 20);
    }

    // QR to public result page (bottom-right)
    $studentId = $studentValue['student_id'] ?? null;
    $examId = $studentValue['exam_id'] ?? null;
    if ($studentId) {
        $queryParams = ['student_id' => $studentId];
        if ($examId) {
            $queryParams['exam_id'] = $examId;
        }
        $publicUrl = $publicResultUrlBase . '?' . http_build_query($queryParams);
        addCardQr($pdf, $publicUrl);
    }
}

// Generate single card by exam_id
if (isset($_GET['exam_id'])) {
    $examId = (int)$_GET['exam_id'];
    $singleQuery = mysqli_query($conn, "
        SELECT se.id AS exam_id, st.*, sc.en_date, c.name AS course_name
        FROM student_exams se
        JOIN students st ON st.student_id = se.student
        LEFT JOIN student_course sc ON sc.s_id = st.student_id
        LEFT JOIN courses c ON c.course_id = se.course
        WHERE se.id = '$examId' AND se.remark = 'passed'
        LIMIT 1
    ");
    $singleStudent = $singleQuery ? mysqli_fetch_assoc($singleQuery) : null;
    if ($singleStudent) {
        renderCard($pdf, $singleStudent, $publicResultUrlBase);
        $pdf->Output();
        exit;
    }
}

// Fallback: generate for filtered set (passed only)
$year = isset($_SESSION['year']) ? $_SESSION['year'] : null;
$courseID = isset($_SESSION['courseID']) ? $_SESSION['courseID'] : null;
$studentsData = [];
if ($year && $courseID) {
    $studentsData = $course->getAllStudentsByCourseAndYear($courseID, $year);
}

foreach ($studentsData as $studentValue) {
    $studentRes = $exam->generateResults($studentValue['student_id']);
    if (!isset($studentRes['average']) || $studentRes['average'] < 70) {
        continue;
    }
    renderCard($pdf, $studentValue, $publicResultUrlBase);
}

$pdf->Output();
exit;
