<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require('../fpdf186/fpdf.php');
require_once '../models/db_connection.php';
// require_once '../models/student_model.php';
// require_once '../models/exam_model.php';
// $exam = new Exam($conn);
// $student = new Student($conn);
// if(isset($_GET['id'])){
// $studentRes = $exam->generateResults($_GET['id']);
// $studentDat = $student->getSingleStudent($_GET['id']);
// $studentDat = $studentDat[0];
    
// }

// var_dump($studentRes);
// die('atleast i have reached');

// die();
class PDF extends FPDF
{
    // Page header
    function Header()
    {
        // Logo and company name
        $this->SetFont('Arial','B',14);
        $this->Cell(0,10,'MTEWELE VOCATIONAL TRAINING CENTER',0,1,'C');
        $this->SetFont('Arial','B',12);
        $this->Cell(0,10,'Exam Results ',0,1,'C');
        
        // Report date
        $this->SetFont('Arial','',10);
        $this->Cell(0,10,'Report Date: '.date('Y-m-d'),0,1,'C');
        
        // Line break
        $this->Ln(10);
    }

    // Page footer
    function Footer()
    {
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial','I',8);
        // Page number
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }

    // Load data
    function LoadData($file)
    {
        // Read file lines
        $lines = file($file);
        $data = array();
        foreach($lines as $line)
            $data[] = explode(',',trim($line));
        return $data;
    }

    // Table
    function ImprovedTable($header, $data)
    {
        // Column widths
        $w = array(8, 54, 55, 15, 15,15,23);
        // Header
        for($i=0;$i<count($header);$i++)
            $this->Cell($w[$i],7,$header[$i],1,0,'C');
        $this->Ln();
        // Data
        $x = 0;
        foreach($data as $row)
        {
            $this->Cell($w[0],6,++$x,'LR');
            $this->Cell($w[1],6,$row[0],'LR');
            $this->Cell($w[2],6,$row[1],'LR');
            $this->Cell($w[3],6,$row[2],'LR',0,'R');
            $this->Cell($w[4],6,$row[3],'LR',0,'R');
            $this->Cell($w[5],6,number_format($row[4]),'LR',0,'R');
            $this->Cell($w[6],6,$row[5],'LR',0,'R');
            $this->Ln();
        }
        // Closing line
        $this->Cell(array_sum($w),0,'','T');
    }
}

$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial','',10);

$examData = null;
if (isset($_GET['id'])) {
    $query = "
        SELECT 
            students.en_id,
            students.fullname,
            students.ident_number,
            students.address,
            students.phone_number,
            student_course.intake,
            student_exams.*,
            courses.name AS course_name,
            courses.subjects
        FROM student_exams
        JOIN students ON students.student_id = student_exams.student
        LEFT JOIN student_course ON students.student_id = student_course.s_id
        LEFT JOIN courses ON courses.course_id = student_exams.course
        WHERE student_exams.id = " . (int)$_GET['id'] . "
        LIMIT 1
    ";
    $getstudent = mysqli_query($conn, $query);
    $examData = mysqli_fetch_assoc($getstudent);
}

if (!$examData) {
    $pdf->Cell(0, 10, 'No exam data found.', 0, 1, 'C');
    $pdf->Output();
    exit;
}

// Decode subject marks
$subjectMarks = [];
if (!empty($examData['subject_marks'])) {
    $decoded = json_decode($examData['subject_marks'], true);
    if (is_array($decoded)) {
        $subjectMarks = $decoded;
    }
}

// Compute average from stored value or from subject marks
$average = isset($examData['average']) ? (float)$examData['average'] : 0;
if ($average === 0 && !empty($subjectMarks)) {
    $average = array_sum($subjectMarks) / max(count($subjectMarks), 1);
}

// Use stored remark if present, otherwise derive from average
$remarkLabel = isset($examData['remark']) ? ucfirst($examData['remark']) : ($average >= 70 ? 'Passed' : 'Failed');

// Student details section
$pdf->SetFont('Arial','B',12);
$pdf->Cell(0,8,'Student Details',0,1);
$pdf->SetFont('Arial','',10);
$pdf->Cell(45,6,'Enrollment ID:',0,0);
$pdf->Cell(0,6,$examData['en_id'],0,1);
$pdf->Cell(45,6,'Fullname:',0,0);
$pdf->Cell(0,6,$examData['fullname'],0,1);
$pdf->Cell(45,6,'Course:',0,0);
$pdf->Cell(0,6,($examData['course_name'] ?? 'N/A'),0,1);
$pdf->Cell(45,6,'Intake:',0,0);
$pdf->Cell(0,6,($examData['intake'] ?? 'N/A'),0,1);
$pdf->Cell(45,6,'Average:',0,0);
$pdf->Cell(0,6,number_format($average,2),0,1);
$pdf->Cell(45,6,'Remark:',0,0);
$pdf->Cell(0,6,$remarkLabel,0,1);
$pdf->Ln(5);

// Subject marks table (with grades)
$pdf->SetFont('Arial','B',12);
$pdf->Cell(0,8,'Subject Marks',0,1);
$pdf->SetFont('Arial','B',10);
$colSubject = 100;
$colMark = 40;
$colGrade = 40;
$lineHeight = 7;
$pdf->Cell($colSubject,$lineHeight,'Subject',1,0,'C');
$pdf->Cell($colMark,$lineHeight,'Mark',1,0,'C');
$pdf->Cell($colGrade,$lineHeight,'Grade',1,1,'C');
$pdf->SetFont('Arial','',10);

// Tanzania grading scale (common NECTA): A 75-100, B 65-74, C 55-64, D 45-54, F <45
function gradeFromMark($mark) {
    if (!is_numeric($mark)) return '-';
    if ($mark >= 75) return 'A';
    if ($mark >= 65) return 'B';
    if ($mark >= 55) return 'C';
    if ($mark >= 45) return 'D';
    return 'F';
}

if (!empty($subjectMarks)) {
    foreach ($subjectMarks as $subjectName => $mark) {
        $startX = $pdf->GetX();
        $startY = $pdf->GetY();

        // Subject cell with wrapping
        $pdf->MultiCell($colSubject, $lineHeight, $subjectName, 1, 'L');
        $endY = $pdf->GetY();
        $rowHeight = $endY - $startY;
        if ($rowHeight < $lineHeight) {
            $rowHeight = $lineHeight;
        }

        // Mark and Grade cells aligned to the top of the row
        $pdf->SetXY($startX + $colSubject, $startY);
        $pdf->Cell($colMark, $rowHeight, $mark, 1, 0, 'C');
        $pdf->Cell($colGrade, $rowHeight, gradeFromMark($mark), 1, 1, 'C');
    }
} else {
    $pdf->Cell($colSubject + $colMark + $colGrade,7,'No subject marks recorded.',1,1,'C');
}

// Output PDF
$pdf->Output();
?>
