<?php
// Include the FPDF library
require('../fpdf186/fpdf.php');
require_once '../models/db_connection.php';

// Fetch student with course info
$studentId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$myData = [];
if ($studentId > 0) {
    $selstudent = mysqli_query($conn, "
        SELECT students.*, courses.name AS course_name, courses.price AS course_price, student_course.en_date
        FROM students
        LEFT JOIN student_course ON students.en_id = student_course.s_id
        LEFT JOIN courses ON courses.course_id = student_course.course_id
        WHERE students.student_id = '$studentId'
        LIMIT 1
    ");
    if ($selstudent) {
        $myData = mysqli_fetch_assoc($selstudent);
    }
}

class PDF extends FPDF {
    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial','I',8);
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
    function headerTitle() {
        $this->SetFont('Arial','B',14);
        $this->Cell(0,10,'Student Details',0,1,'C');
        $this->SetFont('Arial','',10);
        $this->Cell(0,8,'Generated on: '.date('Y-m-d'),0,1,'C');
        $this->Ln(5);
    }
    function infoRow($label, $value) {
        $this->SetFont('Arial','B',11);
        $this->Cell(50,8,$label,0,0);
        $this->SetFont('Arial','',11);
        $this->Cell(0,8,$value,0,1);
    }
}

$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->headerTitle();

if (!$myData) {
    $pdf->SetFont('Arial','',12);
    $pdf->Cell(0,10,'No student data found.',0,1,'C');
    $pdf->Output();
    exit;
}

// Photo
if (!empty($myData['filename']) && file_exists("../uploads/".$myData['filename'])) {
    $pdf->Image("../uploads/".$myData['filename'], 160, 30, 35, 35);
} else {
    if (file_exists("no_image.jpg")) {
        $pdf->Image("no_image.jpg", 160, 30, 35, 35);
    }
}

// Details
$pdf->infoRow('Enrollment ID:', $myData['en_id']);
$pdf->infoRow('Fullname:', $myData['fullname']);
$pdf->infoRow('Age:', $myData['age']);
$pdf->infoRow('Identification No:', $myData['ident_number']);
$pdf->infoRow('Address:', $myData['address'].' '.$myData['street']);
$pdf->infoRow('Phone:', $myData['phone_number']);
$pdf->infoRow('Work:', $myData['work']);
$pdf->infoRow('Education:', $myData['education']);
$pdf->infoRow('Gender:', $myData['gender']);
$pdf->infoRow('Eye Problems:', $myData['eye_problems']);
$pdf->infoRow('Ear Problems:', $myData['ear_problems']);
$pdf->infoRow('Sensitive Case:', $myData['sensitive_case']);
$pdf->Ln(3);
$pdf->SetFont('Arial','B',12);
$pdf->Cell(0,8,'Course Info',0,1);
$pdf->SetFont('Arial','',11);
$pdf->infoRow('Course:', $myData['course_name'] ?? 'N/A');
$pdf->infoRow('Course Price:', isset($myData['course_price']) ? number_format($myData['course_price'],2) : 'N/A');
$pdf->infoRow('Enrollment Date:', $myData['en_date'] ?? 'N/A');

$pdf->Output();
?>
