<?php
require_once '../auth/auth.php';
require_once '../models/db_connection.php';

?>

<!DOCTYPE html>
<html lang="en">

<head>
  <title>Student | Add Student </title>
  <?php include("../templates/header.php"); ?>
</head>

<body>
  <?php
  if (isset($_GET["message"])) {
    $message = $_GET["message"];
    echo "<script>alert('" . $message . "')</script>";
  }
  ?>
  <div class="container-scroller">
    <!-- partial:partials/_navbar.html -->
    <?php include("../templates/nav.php"); ?>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_sidebar.html -->
      <?php include("../templates/sidenav.php"); ?>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">

          <div class="col-lg-12 grid-margin stretch-card">
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">View All Students</h4>
                <p class="card-description">
                  Students Table <code></code>
                </p>
                <div class="table-responsive pt-3">
                  <table class="table table-bordered display" id="example" style="width:100%">
                    <thead>
                      <tr>
                        <th> # </th>
                        <th>Enrollment ID</th>
                        <th> Fullname</th>
                        <th>Identification Number</th>
                        <th> Street</th>
                        <th> Work</th>
                        <th> Address</th>
                        <th> Education</th>
                        <th>Enrollment</th>
                        <?php
                        if ($_SESSION['role'] == 'admin') {
                        ?>
                          <th>Actions</th>
                        <?php
                        }
                        ?>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      $x = 1;
                      $studentsData = mysqli_query($conn, "SELECT * FROM students 
                                         LEFT JOIN student_course ON students.en_id = student_course.s_id 
                                         LEFT JOIN courses ON courses.course_id = student_course.course_id WHERE students.status = 'enrolled'");
                      while ($studentValue = mysqli_fetch_array($studentsData)) {
                      ?>
                        <tr>
                          <td> <?= $x ?></td>
                          <td><?= $studentValue['en_id'] ?></td>
                          <td><?= $studentValue['fullname'] ?></td>
                          <td><?= $studentValue['ident_number'] ?></td>
                          <td><?= $studentValue['street'] ?></td>
                          <td><?= $studentValue['work'] ?></td>
                          <td><?= $studentValue['address'] ?></td>
                          <td><?= $studentValue['education'] ?></td>
                          <td><label class="badge <?php if ($studentValue['status'] == 'enrolled') {
                                                    echo 'badge-success';
                                                  } else {
                                                    echo 'badge-danger';
                                                  } ?>"><?= $studentValue['status'] ?></label></td>
                          <?php
                          if ($_SESSION['role'] == 'admin') {
                            $exam = mysqli_query($conn, "SELECT * FROM student_exams WHERE student = '$studentValue[student_id]' AND remark ='passed'");
                            if(mysqli_num_rows($exam) > 0){
                              echo "<td> marks already entered </td>";
                            } else {
                          ?>
                            <td>
                              <a href="single_marks.php?id=<?= $studentValue['student_id'] ?>"><button type="button" class="btn btn-outline-primary btn-icon-text">
                                  <i class="mdi mdi-file-check btn-icon-prepend"></i>Add Marks </button></a>
                            </td>
                            <?php
                            }
                            ?>
                        </tr>
                    <?php }
                       $x++; } ?>


                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- content-wrapper ends -->
        <!-- partial:partials/_footer.html -->
        <?php include("../templates/footer.php"); ?>

        <!-- partial -->
      </div>
      <!-- main-panel ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
  <?php include("../templates/inc_scripts.php"); ?>
  <script>
    new DataTable('#example');
  </script>
</body>

</html>
