<?php 
require_once '../auth/auth.php';
require_once '../models/db_connection.php';
require_once '../models/student_model.php';
require_once '../models/course_model.php';
require_once '../models/exam_model.php';
$student =  new Student($conn);
$course =  new Course($conn);
$exam =  new Exam($conn);
$coursesData =  $course->getAllCourses();
$examsData =  $exam->getAllExams();
$studentIdArray = array();

if (isset($_POST["search"])) {

  $examID = $_POST["examID"];
  $courseID = $_POST["courseID"];

  $_SESSION['examID'] = $examID ;
  $_SESSION['courseID'] = $courseID ;

  $studentsData =  $course->getAllStudentsByCourse($courseID);

// var_dump($studentsData);
// die();

}

if (isset($_POST["submitMarks"])) {
 
  array_pop($_POST);
  foreach ($_POST as $studentId => $mark) {
    $exam->addStudentMarks($studentId, $_SESSION["examID"],$mark,$_SESSION["courseID"]);
  }
  die();

}


?>

<!DOCTYPE html>
<html lang="en">

<head>
 <title>Student | Add Student </title>
 <?php include("../templates/header.php"); ?>
</head>
<body>
  <div class="container-scroller">
    <!-- partial:partials/_navbar.html -->
    <?php include("../templates/nav.php"); ?>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_sidebar.html -->
      <?php include("../templates/sidenav.php"); ?>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
        <div class="col-md-6 grid-margin stretch-card">
        <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Search Students</h4>
                  <p class="card-description"> 
                    Search students to add <code>Marks</code>                   
                  </p>
                  <form action="fill_marks.php" method="POST">
                  <div class="form-group">
                    <label for="exampleFormControlSelect2">Exam</label>
                    <select class="form-control" id="exampleFormControlSelect2" name="examID">
                      <?php 
                      foreach ($examsData as $examsValue) {?>
                        <option value="<?= $examsValue['id'] ?>" ><?= $examsValue['name'] ?></option>
                     <?php  }?>
                    </select>
                  </div>
                  <div class="form-group">
                    <label for="exampleFormControlSelect2">Course</label>
                    <select class="form-control" id="exampleFormControlSelect2" name="courseID">
                      <?php 
                      foreach ($coursesData as $courseValue) {?>
                        <option value="<?= $courseValue['course_id'] ?>" ><?= $courseValue['name'] ?></option>
                     <?php  }?>
                    </select>
                  </div>
                  
                  <div class="col-sm-9">
                          <button type="submit" name="search" class="btn btn-dark btn-lg ">Search</button>
                  </div>
                </div>
                </form>
              </div>
        </div>
        
        <div class="col-lg-12 grid-margin stretch-card">
 
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Fill Student marks</h4>
                  <p class="card-description">
                    Students Table <code></code>
                  </p>
                  <div class="table-responsive pt-3">
                    <form action="fill_marks.php" method='POST'>
                    <table class="table table-bordered">
                      <thead>
                      <tr>
                          <th> # </th>
                          <th>Enrollment ID</th>
                          <th> Fullname</th>
                          <th>Course Name</th>
                          <th>Fill Mark</th>
                    
                        </tr>
                      </thead>
                      <tbody>
                        <tr>
                        <?php 

                      if (isset($_POST["search"])) {
                       
                            foreach ($studentsData as $studentValue) { 
                                
                                
                              ?>
                          <tr>
                            <td> 1</td>
                            <td><?= $studentValue['en_id'] ?></td>
                            <td><?= $studentValue['fullname'] ?></td>
                            <td><?= $studentValue['name'] ?></td>
                            <td>
                              <div class="col-sm-9">
                                <input type="text" class="form-control" name="<?= $studentValue['student_id'] ?>">
                              </div>
                            </td>
                         
                      <?php }} ?>
                        </tr>
                      </tbody>
                    </table>
                  
                    <br>
                    <?php 
                         if (isset($_POST["search"])) {?>
                              <div class="col-sm-9">
                              <button type="submit" name="submitMarks" class="btn btn-dark btn-lg ">Submit Marks</button>
                              </div>
                        <?php }
                       
                    ?>
                    </form>
                  </div>
                </div>
              </div>
            </div>        
        </div>
        <!-- content-wrapper ends -->
        <!-- partial:partials/_footer.html -->
        <?php include("../templates/footer.php"); ?>
        
        <!-- partial -->
      </div>
      <!-- main-panel ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
    <?php include("../templates/inc_scripts.php"); ?>
</body>

</html>

