<?php
require_once '../models/db_connection.php';

$examId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$examRow = null;

if ($examId > 0) {
    $query = "
        SELECT 
            student_exams.*,
            students.en_id,
            students.fullname,
            students.ident_number,
            students.address,
            students.phone_number,
            students.filename,
            student_course.en_date,
            courses.name AS course_name
        FROM student_exams
        JOIN students ON students.student_id = student_exams.student
        LEFT JOIN student_course ON students.en_id = student_course.s_id
        LEFT JOIN courses ON courses.course_id = student_exams.course
        WHERE student_exams.id = $examId
        LIMIT 1
    ";
    $res = mysqli_query($conn, $query);
    if ($res) {
        $examRow = mysqli_fetch_assoc($res);
    }
}

// Tanzania grading scale helper
function gradeFromMarkLocal($mark) {
    if (!is_numeric($mark)) return '-';
    if ($mark >= 75) return 'A';
    if ($mark >= 65) return 'B';
    if ($mark >= 55) return 'C';
    if ($mark >= 45) return 'D';
    return 'F';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Exam Marks</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
  <div class="container py-5">
    <div class="row justify-content-center">
      <div class="col-12 col-lg-10">
        <div class="card shadow-lg border-0">
          <div class="card-body p-4">
            <div class="d-flex flex-column flex-md-row align-items-center mb-4 border-bottom pb-3">
              <div class="flex-grow-1 text-center text-md-start">
                <h2 class="fw-bold mb-0">Examination Marks</h2>
                <div class="text-muted">Official Results Slip</div>
              </div>
              <?php if (!empty($examRow['filename'])): ?>
                <?php 
                  $imgPath = "../uploads/" . $examRow['filename'];
                  $imgExists = file_exists($imgPath);
                ?>
                <div class="ms-md-3 mt-3 mt-md-0">
                  <div class="rounded-circle overflow-hidden border" style="width:110px;height:110px;">
                    <img src="<?= $imgExists ? $imgPath : '../controllers/no_image.jpg' ?>" alt="Student" style="width:100%;height:100%;object-fit:cover;">
                  </div>
                </div>
              <?php endif; ?>
            </div>

            <?php if (!$examRow) { ?>
              <div class="alert alert-warning">No exam data found.</div>
            <?php } else { 
              $subjectMarks = [];
              if (!empty($examRow['subject_marks'])) {
                $decoded = json_decode($examRow['subject_marks'], true);
                if (is_array($decoded)) {
                  $subjectMarks = $decoded;
                }
              }
              $avg = 0;
              if (!empty($subjectMarks)) {
                $avg = array_sum($subjectMarks) / max(count($subjectMarks), 1);
              } else {
                $avg = $examRow['average'] ?? 0;
              }
              $grade = gradeFromMarkLocal($avg);
              ?>
              <div class="row g-3 mb-4">
                <div class="col-md-6">
                  <div class="p-3 bg-light rounded">
                    <p class="mb-2"><strong>Enrollment ID:</strong> <?= htmlspecialchars($examRow['en_id']) ?></p>
                    <p class="mb-2"><strong>Student:</strong> <?= htmlspecialchars($examRow['fullname']) ?></p>
                    <p class="mb-2"><strong>Course:</strong> <?= htmlspecialchars($examRow['course_name'] ?? 'N/A') ?></p>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="p-3 bg-light rounded">
                    <p class="mb-2"><strong>Exam ID:</strong> <?= htmlspecialchars($examRow['id']) ?></p>
                    <p class="mb-2"><strong>Average:</strong> <?= number_format($avg, 2) ?> (Grade <?= $grade ?>)</p>
                    <p class="mb-2"><strong>Remark:</strong> <?= htmlspecialchars($examRow['remark']) ?></p>
                  </div>
                </div>
              </div>

              <div class="table-responsive">
                <table class="table table-bordered align-middle">
                  <thead class="table-light">
                    <tr>
                      <th style="width:55%;">Subject</th>
                      <th style="width:20%;">Mark</th>
                      <th style="width:25%;">Grade</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php if (!empty($subjectMarks)) {
                      foreach ($subjectMarks as $subjectName => $mark) { ?>
                        <tr>
                          <td><?= htmlspecialchars($subjectName) ?></td>
                          <td><?= htmlspecialchars($mark) ?></td>
                          <td><?= gradeFromMarkLocal($mark) ?></td>
                        </tr>
                      <?php }
                    } else { ?>
                      <tr><td colspan="3" class="text-center">No subject marks recorded.</td></tr>
                    <?php } ?>
                  </tbody>
                </table>
              </div>
            <?php } ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
</html>
