<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once '../auth/auth.php';
require_once '../models/db_connection.php';
require_once '../models/expense_model.php';
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <title>Expenses | Add Expenses </title>
  <?php include("../templates/header.php"); ?>
</head>

<body>
  <div class="container-scroller">
    <!-- partial:partials/_navbar.html -->
    <?php include("../templates/nav.php"); ?>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_sidebar.html -->
      <?php include("../templates/sidenav.php"); ?>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="row">


            <div class="col-md-6 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h1>AVAILABLE CASH: <span style="color:green">
                      <?php
                      $dep = mysqli_query($conn, "SELECT * FROM cash_deposits");
                      $totaldep = 0;
                      while ($fetchdep = mysqli_fetch_array($dep)) {
                        $totaldep = $totaldep + $fetchdep['ammount'];
                      }
                      $totalexp = 0;
                      $exp = mysqli_query($conn, "SELECT * FROM expenses");
                      while ($fetchexp = mysqli_fetch_array($exp)) {
                        $totalexp += $fetchexp['ammount'];
                      }

                      echo number_format($diff = $totaldep - $totalexp);
                      ?>
                    </span></h1>
                </div>
              </div>
            </div>
          </div>
          <div class="col-md-6 grid-margin stretch-card">
            <?php
            if ($diff != 0) {
            ?>
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Add Expenses</h4>

                  <form action="expense.php" method="POST">
                    <div class="form-group">
                      <label for="exampleFormControlSelect2">Expense</label>
                      <input type="text" class="form-control" name="expense" required>
                    </div>
                    <div class="form-group">
                      <label for="exampleFormControlSelect2">Amount</label>
                      <input type="number" class="form-control" name="amount" max="<?php if (isset($diff)) {
                                                                                      echo $diff;
                                                                                    } ?>" required>
                    </div>

                    <div class="form-group">
                      <label for="exampleFormControlSelect2">Date</label>
                      <input required type="date" class="form-control" name="issuedDate" required>
                    </div>

                    <div class="form-group">
                      <label for="exampleFormControlSelect2">Narration</label>
                      <input required type="text" class="form-control" name="narration" required>
                    </div>

                    <div class="col-sm-9">
                      <input type="submit" name="addExpense" class="btn btn-dark btn-lg " value="Add Expense">
                    </div>
                </div>
                </form>
              </div>
            <?php
            } else {
              echo "You cannot add any Expense at the moment";
            }
            ?>
          </div>

        </div>
        <!-- content-wrapper ends -->
        <!-- partial:partials/_footer.html -->
        <?php include("../templates/footer.php"); ?>

        <!-- partial -->
      </div>
      <!-- main-panel ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
  <?php include("../templates/inc_scripts.php"); ?>
</body>

</html>