<?php 
require_once('db_connection.php');
class Student  
{
    private $db;
    function __construct($dbconn){
        $this->db = $dbconn;
    }

    // Function to fetch all students
    public function getAllStudents() {
        $query = "SELECT * FROM students";
        $result =  mysqli_query($this->db,$query);
        $data = mysqli_fetch_all( $result,MYSQLI_ASSOC);
        return $data;
    }
    public function getSingleStudent($id) {
        $query = "SELECT * FROM `student_course` 
        JOIN students ON students.student_id = student_course.student_id
        WHERE student_course.student_id = $id";
        $result =  mysqli_query($this->db,$query);
        $data = mysqli_fetch_all( $result,MYSQLI_ASSOC);
        return $data;
    }

 public function createStudent($enrollmentId, $fullname, $identNumber, $street, $address, $work, $education, $gender, $phoneNumber, $eyeProblems, $earProblems, $sensitiveCase,$filename,$user,$age) {
        $query = "INSERT INTO students (en_id, fullname, ident_number, street, address, work, education, gender, phone_number, eye_problems, ear_problems, sensitive_case,filename,reg_by,age) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
        $stmt = $this->db->prepare($query);
        $stmt->bind_param("sssssssssssssss", $enrollmentId, $fullname, $identNumber, $street, $address, $work, $education, $gender, $phoneNumber, $eyeProblems, $earProblems, $sensitiveCase,$filename,$user,$age);
        
        // Execute the statement
       if ($stmt->execute()) {
        return array("success" => true, "message" => "Student created successfully");
    } else {
        return array("success" => false, "message" => $stmt->error); // Failed to create student, return error message
    }
    }


    public function editStudent($studentId,$fullname,$identNumber,$street,$address,$work,$education,$gender,$phoneNumber,$eyeProblems,$earProblems,$sensitiveCase,$file_name,$certnumber) {
            // Query to update the student record
                $query = "UPDATE students SET 
                fullname = '$fullname',
                ident_number = '$identNumber',
                street = '$street',
                address = '$address',
                work = '$work',
                education = '$education',
                gender = '$gender',
                phone_number = '$phoneNumber',
                eye_problems = '$eyeProblems',
                ear_problems = '$earProblems',
                en_id = '$certnumber',
                sensitive_case = '$sensitiveCase'";
                
            // If a new image is uploaded, update the image field
            if ($file_name !== '') {
            $query .= ", filename = '$file_name'";
            }
                
            $query .= " WHERE student_id = $studentId";

            
           $result =  mysqli_query($this->db,$query);
           return $result;

        }

    public function generateEnrollmentId($regionCode = '025', $courseInitial = 'HGV', $intakeNumber = 1) {
        $regionCode = $this->sanitizeRegionCode($regionCode, '025');
        $courseInitial = $this->sanitizeCourseInitial($courseInitial, 'HGV');
        $intake = max(1, (int)$intakeNumber);

        $studentNumber = str_pad((string)$this->getNextStudentNumber(), 4, '0', STR_PAD_LEFT);
        $yearPart = date('y');

        return sprintf('M%s/%s/%d%s/%s', $regionCode, $courseInitial, $intake, $studentNumber, $yearPart);
    }

     // Function to return student ID given enrollment ID
     public function getStudentIdByEnrollmentId($enrollmentId) {
        $query = "SELECT student_id FROM students WHERE en_id = ?";
        $stmt = $this->db->prepare($query);
        $stmt->bind_param("s", $enrollmentId);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            return $row['student_id']; // Return student ID
        } else {
            return null; // No student found with the given enrollment ID
        }
    }

    public function isStudentEnrolled($studentId) {
        $query = "SELECT * FROM student_course WHERE student_id = ?";
        $stmt = $this->db->prepare($query);
        $stmt->bind_param("s", $studentId);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            return true; // Student is enrolled
        } else {
            return false; // Student is not enrolled
        }
    }

    public function deleteStudent($studentId) {
        $query = "DELETE FROM students WHERE `students`.`student_id` = ?";
        $stmt = $this->db->prepare($query);
        $stmt->bind_param("s", $studentId);
        $stmt->execute();
        $result = $stmt->get_result();

        return $result;
    }

    private function sanitizeRegionCode($regionCode, $default) {
        $digits = preg_replace('/\D/', '', (string)$regionCode);
        if ($digits === '') {
            $digits = $default;
        }
        return str_pad(substr($digits, 0, 3), 3, '0', STR_PAD_LEFT);
    }

    private function sanitizeCourseInitial($courseInitial, $default) {
        $letters = strtoupper(preg_replace('/[^A-Z]/', '', (string)$courseInitial));
        if ($letters === '') {
            $letters = $default;
        }
        return $letters;
    }

    private function getNextStudentNumber() {
        $query = "SELECT MAX(student_id) AS last_id FROM students";
        $result = mysqli_query($this->db,$query);
        $row = $result ? mysqli_fetch_array($result) : null;
        $lastId = isset($row['last_id']) ? (int)$row['last_id'] : 0;
        return $lastId + 1;
    }
}




