<?php

require_once '../auth/auth.php';
require_once '../models/db_connection.php';
if (isset($_POST['enrollStudent'])) {
    // Validate input
    $studentIdInput = mysqli_real_escape_string($conn, $_POST['enID']); // now posting student_id instead of enrollment id
    $courseID = mysqli_real_escape_string($conn, $_POST['courseID']);
    $enDate = mysqli_real_escape_string($conn, $_POST['enDate']);
    $intake = mysqli_real_escape_string($conn, $_POST['intake']);

    // Resolve the student record by student_id (requested: do not rely on enrollment id)
    $studentRes = mysqli_query($conn, "SELECT student_id, en_id FROM students WHERE student_id = '$studentIdInput' LIMIT 1");
    if (!$studentRes || mysqli_num_rows($studentRes) === 0) {
        $err = 'Student not found. Please select a valid student.';
    } else {
        $studentRow = mysqli_fetch_assoc($studentRes);
        $studentId = $studentRow['student_id'];
        $enrollmentId = $studentRow['en_id'];

        // Determine which column to use for linking the student (prefer student_id)
        $studentIdColumn = 's_id';
        $colCheck = mysqli_query($conn, "SHOW COLUMNS FROM student_course LIKE 'student_id'");
        if ($colCheck && mysqli_num_rows($colCheck) > 0) {
            $studentIdColumn = 'student_id';
        }

        $checkEnrollment = mysqli_query($conn, "SELECT * FROM student_course WHERE $studentIdColumn = '$studentId' AND course_id = '$courseID'");
        if ($checkEnrollment && mysqli_num_rows($checkEnrollment) > 0) {
            $err = 'Student is already enrolled in this course.';
        } else {
            // Insert into student_course using student_id as the primary link; include s_id for compatibility when available
            $columns = "$studentIdColumn, course_id, en_date, intake";
            $values = "'$studentId', '$courseID', '$enDate', '$intake'";

            $sIdColumnExists = mysqli_query($conn, "SHOW COLUMNS FROM student_course LIKE 's_id'");
            if ($sIdColumnExists && mysqli_num_rows($sIdColumnExists) > 0 && $studentIdColumn !== 's_id') {
                // Also store enrollment id for legacy lookups while linking by student_id
                $columns = "$studentIdColumn, s_id, course_id, en_date, intake";
                $values = "'$studentId', '$enrollmentId', '$courseID', '$enDate', '$intake'";
            }

            $enroll = mysqli_query($conn, "INSERT INTO student_course ($columns) VALUES ($values)");

            if ($enroll) {
                // Update student status
                $st = mysqli_query($conn, "UPDATE students SET status = 'enrolled' WHERE student_id = '$studentId'");

                if ($st) {
                    $succ = 'Student enrolled successfully';
                } else {
                    $err = 'Failed to update student status. Please try again.';
                }
            } else {
                $err = 'Enrollment failed: ' . mysqli_error($conn);
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Loading Spinner</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .loading-message {
            font-size: 24px;
            font-weight: bold;
            text-align: center;
            margin-top: 20px;
        }
    </style>
</head>

<body>
    <div class="d-flex flex-column align-items-center justify-content-center vh-100">
        <!-- Bootstrap Spinner -->
        <div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;">
            <span class="visually-hidden">Loading...</span>
        </div>
        <!-- Message -->
        <div class="loading-message">
            Please wait, enrolling student...<br/>
            <?php
            if (isset($succ)) {
                echo $succ;
                echo "<script>
          setTimeout(() => {
              window.location.href = 'view_students.php';
          }, 3000);
      </script>";
            } else {
                echo isset($err) ? $err : 'Enrollment failed.';
                echo "<script>
          setTimeout(() => {
              window.location.href = 'enroll_student.php';
          }, 3000);
      </script>";

            }
            ?>
        </div>
    </div>

    <!-- Bootstrap JS (Optional, for interactive components) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
