<?php
require_once '../auth/auth.php';
require_once '../models/db_connection.php';
require_once '../models/course_model.php';

$course = new Course($conn);
$courses = $course->getAllCourses();





?>

<!DOCTYPE html>
<html lang="en">

<head>
  <title>Courses </title>
  <?php include("../templates/header.php"); ?>
  <script type='text/javascript'>
    function ConfirmDelete() {
      if (confirm("Are you sure you want to delete this course?"))
        return true;
      else
        return false;
    }
  </script>
</head>

<body>
  <?php
  if (isset($_GET["message"])) {
    $message = $_GET["message"];
    echo "<script>alert('" . $message . "')</script>";
  }
  ?>
  <div class="container-scroller">
    <!-- partial:partials/_navbar.html -->
    <?php include("../templates/nav.php"); ?>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_sidebar.html -->
      <?php include("../templates/sidenav.php"); ?>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">

          <div class="col-lg-12 grid-margin stretch-card">
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">View All Course</h4>
                <p class="card-description">
                  Course Table <code></code>
                </p>
                <div class="table-responsive pt-3">
                  <table class="table table-bordered display" id="example" style="width:100%">
                    <thead>
                      <tr>
                        <th> # </th>
                        <th>Course Name</th>
                        <th>Course Price</th>
                        <th> Course Duration</th>
                        <th>Subjects</th>
                        <?php if ($_SESSION['role'] == 'admin') { ?>
                          <th>Options</th>
                        <?php
                        }
                        ?>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      $x = 0;

                      foreach ($courses  as $singleCourse) { ?>
                        <tr>
                          <td><?= ++$x ?></td>
                          <td><?= $singleCourse['name'] ?></td>
                          <td><?= $singleCourse['price'] ?></td>
                          <td><?= $singleCourse['description'] ?></td>
                          <td>
                            <?php
                            $subjects = [];
                            if (!empty($singleCourse['subjects'])) {
                              $subjects = json_decode($singleCourse['subjects'], true) ?: [];
                            }
                            echo count($subjects);
                            ?>
                          </td>
                          <?php if ($_SESSION['role'] == 'admin') { ?>
                            <td>
                              <a href="edit_course.php?id=<?= $singleCourse['course_id'] ?>">
                                <button type="button" class="btn btn-outline-secondary btn-icon-text">
                                  <i class=" fa fa-pencil"></i> </button></a>

                              <a onclick='return ConfirmDelete()' href="delete_course.php?id=<?= $singleCourse['course_id'] ?>">
                                <button
                                  type="button" class="btn btn-primary btn-icon-text">
                                  <i class="fa fa-trash"></i> </button></a>

                            </td>
                          <?php
                          }
                          ?>
                        </tr>
                      <?php } ?>


                    </tbody>
                  </table>
                </div>
                <div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- content-wrapper ends -->
        <!-- partial:partials/_footer.html -->
        <?php include("../templates/footer.php"); ?>

        <!-- partial -->
      </div>
      <!-- main-panel ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
  <?php include("../templates/inc_scripts.php"); ?>
  <script>
    new DataTable('#example');
  </script>
</body>

</html>
